<?php
ini_set('display_errors', 0);
ini_set('display_startup_errors', 0);
error_reporting(0);
ob_start();

$ip = $_SERVER['HTTP_CF_CONNECTING_IP'] ?? $_SERVER['HTTP_X_FORWARDED_FOR'] ?? $_SERVER['REMOTE_ADDR'];

file_put_contents('debug_log.txt', "Script start for IP: $ip\n", FILE_APPEND);

$blacklistFile = 'blacklist.txt';
$whitelistFile = 'whitelist.txt';
$errorLogFile = 'errorpaid.txt';
$debugLogFile = 'debug_log.txt';

$redirectLinks = [
    'https://www.google.com',
    'https://bbc.com',
    'https://cnn.com',
    'https://nytimes.com',
    'https://github.com',
    'https://stackoverflow.com',
    'https://openai.com',
    'https://buzzfeed.com'
];

// Fungsi redirect
function redirectToRandomLink($links) {
    $randomLink = $links[array_rand($links)];
    header("Location: $randomLink");
    exit;
}

// Load whitelist
$whitelistedIps = file_exists($whitelistFile)
    ? file($whitelistFile, FILE_IGNORE_NEW_LINES | FILE_SKIP_EMPTY_LINES)
    : [];

file_put_contents('debug_log.txt', "Whitelist loaded: " . implode(", ", $whitelistedIps) . "\n", FILE_APPEND);

if (in_array($ip, $whitelistedIps)) {
    file_put_contents('debug_log.txt', "IP $ip is whitelisted, skipping checks.\n", FILE_APPEND);
    return; // pakai return, bukan exit, agar index.php tetap jalan
}

// Load blacklist
$blacklistedIps = file_exists($blacklistFile)
    ? file($blacklistFile, FILE_IGNORE_NEW_LINES | FILE_SKIP_EMPTY_LINES)
    : [];

if (in_array($ip, $blacklistedIps)) {
    file_put_contents('debug_log.txt', "IP $ip is blacklisted, redirecting.\n", FILE_APPEND);
    redirectToRandomLink($redirectLinks);
}

$curl = curl_init();
curl_setopt_array($curl, [
    CURLOPT_URL => "https://netdetective.p.rapidapi.com/query?ipaddress=$ip",
    CURLOPT_RETURNTRANSFER => true,
    CURLOPT_TIMEOUT => 10,
    CURLOPT_HTTP_VERSION => CURL_HTTP_VERSION_1_1,
    CURLOPT_CUSTOMREQUEST => "GET",
    CURLOPT_HTTPHEADER => [
        "x-rapidapi-host: netdetective.p.rapidapi.com",
        "x-rapidapi-key: 75e8453762msh7468ac30ace46f0p1c87e1jsnd0f151ae82f3"
    ],
]);

$response = curl_exec($curl);

if ($response === false) {
    $err = curl_error($curl);
    file_put_contents($errorLogFile, "cURL failed: $err\nIP: $ip\n", FILE_APPEND);
    exit;
}

curl_close($curl);

file_put_contents($debugLogFile, "API response: $response\n", FILE_APPEND);

$data = json_decode($response, true);
file_put_contents($debugLogFile, "JSON decode: " . print_r($data, true) . "\n", FILE_APPEND);

if (!$data || !isset($data['result'])) {
    file_put_contents($errorLogFile, "Invalid API response for IP: $ip\n", FILE_APPEND);
    exit;
}

$flags = $data['result'];

$isSuspicious = (
    $flags['isVpn'] ||
    $flags['isDataCenter'] ||
    $flags['isBruteForce'] ||
    $flags['isSpam'] ||
    $flags['isBogon'] ||
    $flags['isZombie'] ||
    $flags['isCompromised'] ||
    $flags['isProxyHttp'] ||
    $flags['isProxySocks'] ||
    $flags['isDDos']
);

if ($isSuspicious) {
    if (!in_array($ip, $blacklistedIps)) {
        file_put_contents($blacklistFile, $ip . PHP_EOL, FILE_APPEND);
        file_put_contents($debugLogFile, "IP $ip added to blacklist\n", FILE_APPEND);
    }
    redirectToRandomLink($redirectLinks);
}

ob_end_flush();
?>
